000010  IDENTIFICATION DIVISION.
000020*-----------------------
000030  PROGRAM-ID.             BARCODING.
000040* AUTHOR.                 C Nguyen.
000050* INSTALLATION.           ASPECT.
000060* DATE-WRITTEN.           18-May-1998.
000070*=================================================================
000080*  Title    : Australia Post Barcode Demonstration.
000090*  Version  : r2
000100*  Date     : 5th March 1999.
000110*  Language : Cobol (ANSI-85)
000120*
000130*  Description:
000140*  ------------
000150*  This software module generates 4-states barcode digits with
000160*  Reed-Solomon error detection and correction algorithm.
000170*
000180*  It includes a main program for demonstrating barcode generation.
000190*  The program prompts the user for the Format Control Code, the sorting
000200*  code and optionally, a User Information String.  It then invoke
000210*  the routine BuildBarcode to generate the barcode string.
000220*
000230*  Disclaimer
000240*  ----------
000250*  Whilst Australia Post provides this program in good faith, no
000260*  responsibility is taken as to its accuracy. The program is
000270*  provided for guidance only. Australia Post shall not be liable
000280*  for any loss or damage arising from the use of, or reliance placed
000290*  on, any information provided by it.
000300*
000310*  Modification History
000320*  --------------------
000330*
000340*  Date         Who    Ref Number  Description
000350*  --------     ---    ---------   --------------------------------
000360*  18-May-1998  CN                 Initial version
000370*  03-Mar-1999  DW     R2          Realigned with ANSI-C version R2
000375*  06-May-1999  TW                 Converted to ANSI 85 Format
000380*==================================================================
000390  ENVIRONMENT DIVISION.
000400*--------------------
000410  CONFIGURATION SECTION.
000420
000430  SOURCE-COMPUTER.        VAX.
000440  OBJECT-COMPUTER.        VAX.
000450
000460  DATA DIVISION.
000470*------------
000480  WORKING-STORAGE SECTION.
000490*----------------------
000500
000510  01  i pic 9(9) comp.
000520  01  j pic 9(9) comp.
000530
000540  01  w_text pic x(80).
000550  01  w_len pic s9(9) comp.
000560  01  w_result pic -(8)9.
000570  01  w_idx pic s9(9) comp.
000580  01  w_idx_2 pic s9(9) comp.
000590  01  w_bc.
000600      03 w_bc_fill.
000610         05 filler pic xxxx value "||  ".
000620         05 filler pic xxxx value "||||".
000630         05 filler pic xxxx value "| | ".
000640      03 w_bc_arr1 redefines w_bc_fill occurs 3 times.
000650         05 w_bc_arr2 occurs 4 times pic x.
000660
000670
000680  01  iResult pic s9(9) comp.
000690  01  sFCC pic x(3) value "11".
000700  01  sSortingCode pic 9(8) value 39549554.
000710  01  sCustInfo.
000720      03 sCustInfo_arr occurs 32 times pic x.
000730  01  sBarCode.
000740      03 sBarcode_arr occurs 68 times pic x.
000750  01  iBarCodeLen pic s9(6) comp.
000760
000770  01  w_user_request pic x.
000780      88  w_user_request_continue values 'Y','y'.
000790      88  w_user_request_exit value 'N','n'.
000800
000810  PROCEDURE DIVISION.
000820*------------------
000830  MAIN SECTION.
000840*------------
000850  MAIN-START.
000860      set w_user_request_continue to true
000870
000880      display "Australia Post Barcode Demo.  Cobol-85 version R2
000890-     " 3rd March 1999."
000900      display ""
000910
000920      perform until w_user_request_exit
000930          initialize sCustInfo
000940*
000950*       accept input
000960*
000970          display "Please Enter Format Control Code (99) : "
000980                  with no advancing
000990          accept sFCC
001000
001010          display "Please Enter Sorting Code (99999999)  : "
001020                  with no advancing
001030          accept sSortingCode
001040
001050          display "Please Enter Customer Information     : "
001060                  with no advancing
001070          accept sCustInfo
001080
001090*       terminate variable length User Info with NULL (LOW-VALUE)
001100          perform varying w_len from 32 by -1
001110             until w_len < 1 or sCustInfo_arr(w_len) not = space
001130              continue
001140          end-perform
001150          move LOW-VALUE to sCustInfo_arr(w_len + 1)
001160
001170*    terminate variable length barcode buffer with NULL (LOW-VALUE)
001180          move LOW-VALUE to sBarCode
001190
001200         initialize sBarcode, iBarcodeLen
001210*       build the barcode now
001220         display "bin="sBarcode
001230          call "BuildBarcode" using sFCC
001240                                   ,sSortingCode
001250                                   ,sCustInfo
001260                                   ,sBarCode
001270                                   ,iBarCodeLen
001280                             giving iResult
001290         display "bout="sBarcode
001300
001310*       display input
001320          move iResult to w_result
001330          display "        Return Code = " w_result
001340          display "Format Control Code = " sFCC
001350          display "       Sorting Code = " sSortingCode
001360*  display user format input (must determine the actual length)
001370*       (Note variable length is null terminated)
001380          perform varying w_len from 1 by 1
001390                    until w_len >= 32
001400                       or sCustInfo_arr(w_len) = LOW-VALUE
001410              continue
001420          end-perform
001430          if w_len > 1
001440              display "   Free Format Code = " sCustInfo
001450          else
001460              display "   Free Format Code = "
001470          end-if
001480*       determine the length of the returned bar code
001490*       break the bar code into <start> <triplet...> <stop>
001500
001510         display "Bar Code:"
001520*
001530          perform varying i from 1 by 1 until i > 3
001540                 display "    " with no advancing
001550
001560                 perform varying j from 1 by 1 until j >
001570-    iBarcodeLen
001580                         move sBarcode_arr(j) to w_idx
001590*    display "arr="sBarcode_arr(j)" w_idx="w_idx with conversion"
001600
001610             display w_bc_arr2(i, w_idx + 1) with no advancing
001630                 end-perform
001640                 display ""
001650          end-perform
001660          display "    " sBarCode
001670          display " "
001680          display " "
001690          move spaces to w_user_request
001700          perform until w_user_request_continue
001710                     or w_user_request_exit
001720              display "                       Continue (Y/N) ? "
001730                  with no advancing
001740              accept w_user_request
001750          end-perform
001760      end-perform
001770      .
001780  MAIN-EXIT.
001790      STOP RUN.
001800  END PROGRAM barcoding.
001810
001820
001830
001840
001850
001860
001870
001880
001890
001900
001910
001920  IDENTIFICATION DIVISION.
001930*-----------------------
001940  PROGRAM-ID.             BuildBarcode.
001950* AUTHOR.                 C Nguyen.
001960* INSTALLATION.           ASPECT.
001970* DATE-WRITTEN.           18-May-1998.
001980*=================================================================
001990*  Description:
002000*  ------------
002010*   This routine is a clone of the C function BuildBarcode.c which
002020*   validates input parameters and returns the barcode string.
002030*
002040*  Input:
002050*   - sFcc     Input string - Format Control Code (Two digits '99').
002060*   - sSortingCode Input string   - Delivery Point ID
002070*                                   (Eight digits '99999999').
002080*   - sCustInfo Input string - Free format Customer Information Field
002090*                              (Null term. up to 255 bytes string).
002100*
002110*  Output:
002120*   - BarCode      Output string  - Resultant barcode digits
002130*                            (Null term. up to 255 bytes string).
002140*   - BarCodeLen   Output numeric - Length of the barcode
002150*
002160*  Modification History
002170*  --------------------
002180*  Date         Who  Ref Number   Description
002190*  -----------  ---  ----------   ------------------------------
002200*  18-May-1998  CN                Initial version
002210*  03-Mar-1998  DW   R2           Realigned with ANSI-C version R2
002220*=================================================================
002230  ENVIRONMENT DIVISION.
002240*--------------------
002250  DATA DIVISION.
002260*------------
002270  WORKING-STORAGE SECTION.
002280*----------------------
002290  01  w_puesdo_constants.
002300         03 w_BC_START_SYM               PIC XX value "13".
002310         03 w_BC_STOP_SYM                PIC XX value "13".
002320
002330  01  w_range.
002340         03 w_istart                     pic s9(9) comp.
002350         03 w_iend                       pic s9(9) comp.
002360
002370  01  w_exit_status pic s9(9) comp.
002380         88 w_exit_stat_OK             value    0.
002390         88 w_exit_stat_INV_FCC        value    1.
002400         88 w_exit_stat_INV_SORT_CODE  value    2.
002410         88 w_exit_stat_INV_CUST_INFO  value    3.
002420         88 w_exit_stat_INV_ENCODE_STR value    4.
002430
002440  01  w_sBarCode                 pic x(67).
002450  01  w_conversionString         pic x(20).
002460  01  w_conversionType           pic x.
002470
002480  LINKAGE SECTION.
002490*---------------
002500  01  l_sFcc pic x(2).
002510         88 l_sFcc_length_37 values "11", "45", "87", "92".
002520         88 l_sFcc_length_52 values "59".
002530         88 l_sFcc_length_67 values "62", "44".
002540
002550
002560  01  l_sSortingCode pic x(8).
002570
002580  01  l_sCustInfo pic x(32).
002590
002600  01  l_sBarcode.
002610         03 l_sBarcode_arr occurs 68 times pic x.
002620
002630  01  l_iBarcodeLen pic s9(6) comp.
002640
002650  PROCEDURE DIVISION
002660         using
002670                 l_sFcc,
002680                 l_sSortingCode,
002690                 l_sCustInfo,
002700                 l_sBarcode,
002710                 l_iBarcodeLen
002720         giving w_exit_status.
002730*----------------------------------------------------------------
002740  MAIN SECTION.
002750*------------
002760  MAIN-START.
002770         set w_exit_stat_OK to true.
002780         initialize w_sBarcode
002790
002800         evaluate true
002810                 when l_sFcc_length_37
002820                         perform BuildBarcode37
002830                 when l_sFcc_length_52
002840                         perform BuildBarcode52
002850                 when l_sFcc_length_67
002860                         perform BuildBarcode67
002870                 when other
002880                         set w_exit_stat_INV_FCC to true
002890         end-evaluate.
002900
002910  MAIN-EXIT.
002920      EXIT PROGRAM.
002930
002940 BuildBarcode37.
002950*---------------------------------------------------------------
002960* Build a length 37 barcode from an Fcc and a sorting code
002970*---------------------------------------------------------------
002980
002990*
003000* Start Bars
003010*
003020         move 01 to              w_istart
003030         move 02 to              w_iend
003040         move 'B' to             w_conversionType
003050         move w_BC_START_SYM to  w_conversionString
003060
003070         perform InsertIntoBarcode
003080*
003090* Format Control Code
003100*
003110         if w_exit_stat_OK
003120                 move 03 to      w_istart
003130                 move 06 to      w_iend
003140                 move 'N' to     w_conversionType
003150                 move l_sFcc to  w_conversionString
003160
003170                 perform InsertIntoBarcode
003180
003190                 if not w_exit_stat_OK
003200                         set w_exit_stat_INV_FCC to true
003210                 end-if
003220         end-if
003230*
003240* Sorting Code
003250*
003260         if w_exit_stat_OK
003270                 move 07                 to w_istart
003280                 move 22                 to w_iend
003290                 move 'N'                to w_conversionType
003300                 move l_sSortingCode     to w_conversionString
003310
003320                 perform InsertIntoBarcode
003330
003340                 if not w_exit_stat_OK
003350                         set w_exit_stat_INV_SORT_CODE to true
003360                 end-if
003370         end-if
003380*
003390* Fill Character '3'
003400*
003410         if w_exit_stat_OK
003420                 move 23 to w_istart
003430                 move 23 to w_iend
003440                 move 'B' to     w_conversionType
003450                 move '3' to     w_conversionString
003460
003470                 perform InsertIntoBarcode
003480         end-if
003490*
003500* Parity Symbols
003510*
003520         if w_exit_stat_OK
003530                 move 37 to w_iend
003540                 perform AppendRSParity
003550         end-if
003560*
003570* Stop Bars
003580*
003590         if w_exit_stat_OK
003600                 move 36 to              w_istart
003610                 move 37 to              w_iend
003620                 move 'B' to             w_conversionType
003630                 move w_BC_STOP_SYM to   w_conversionString
003640
003650                 perform InsertIntoBarcode
003660         end-if
003670*
003680* Return result
003690*
003700         if w_exit_stat_OK
003710                 move w_sBarcode to l_sBarcode
003720                 move 37 to l_iBarcodeLen
003730         end-if
003740         .
003750
003760
003770
003780 BuildBarcode52.
003790*---------------------------------------------------------------
003800* Build a length 52 barcode from an Fcc, a sorting code and
003810* customer supplied information
003820*---------------------------------------------------------------
003830
003840*
003850* Start Bars
003860*
003870         move 01 to              w_istart
003880         move 02 to              w_iend
003890         move 'B' to             w_conversionType
003900         move w_BC_START_SYM to  w_conversionString
003910
003920         perform InsertIntoBarcode
003930
003940*
003950* Format Control Code
003960*
003970         if w_exit_stat_OK
003980                 move 03 to      w_istart
003990                 move 06 to      w_iend
004000                 move 'N' to     w_conversionType
004010                 move l_sFcc to  w_conversionString
004020
004030                 perform InsertIntoBarcode
004040
004050                 if not w_exit_stat_OK
004060                         set w_exit_stat_INV_FCC to true
004070                 end-if
004080         end-if
004090*
004100* Sorting Code
004110*
004120         if w_exit_stat_OK
004130                 move 07                 to w_istart
004140                 move 22                 to w_iend
004150                 move 'N'                to w_conversionType
004160                 move l_sSortingCode     to w_conversionString
004170
004180                 perform InsertIntoBarcode
004190
004200                 if not w_exit_stat_OK
004210                         set w_exit_stat_INV_SORT_CODE to true
004220                 end-if
004230         end-if
004240*
004250* Customer Information
004260*
004270         if w_exit_stat_OK
004280                 move 23                 to w_istart
004290                 move 38                 to w_iend
004300                 move 'C'                to w_conversionType
004310                 move l_sCustInfo        to w_conversionString
004320
004330                 perform InsertIntoBarcode
004340         end-if
004350*
004360* Parity Symbols
004370*
004380         if w_exit_stat_OK
004390                 move 52 to w_iend
004400                 perform AppendRSParity
004410         end-if
004420*
004430* Stop Bars
004440*
004450         if w_exit_stat_OK
004460                 move 51 to              w_istart
004470                 move 52 to              w_iend
004480                 move 'B' to             w_conversionType
004490                 move w_BC_STOP_SYM to   w_conversionString
004500
004510                 perform InsertIntoBarcode
004520         end-if
004530*
004540* Copy back result
004550*
004560         if w_exit_stat_OK
004570                 move w_sBarcode to l_sBarcode
004580                 move 52 to l_iBarcodeLen
004590         end-if
004600         .
004610
004620 BuildBarcode67.
004630*---------------------------------------------------------------
004640* Build a length 67 barcode from an Fcc, a sorting code and
004650* customer supplied information
004660*---------------------------------------------------------------
004670
004680*
004690* Start Bars
004700*
004710         move 01 to              w_istart
004720         move 02 to              w_iend
004730         move 'B' to             w_conversionType
004740         move w_BC_START_SYM to  w_conversionString
004750
004760         perform InsertIntoBarcode
004770
004780*
004790* Format Control Code
004800*
004810         if w_exit_stat_OK
004820                 move 03 to      w_istart
004830                 move 06 to      w_iend
004840                 move 'N' to     w_conversionType
004850                 move l_sFcc to  w_conversionString
004860
004870                 perform InsertIntoBarcode
004880
004890                 if not w_exit_stat_OK
004900                         set w_exit_stat_INV_FCC to true
004910                 end-if
004920         end-if
004930*
004940* Sorting Code
004950*
004960         if w_exit_stat_OK
004970                 move 07                 to w_istart
004980                 move 22                 to w_iend
004990                 move 'N'                to w_conversionType
005000                 move l_sSortingCode     to w_conversionString
005010
005020                 perform InsertIntoBarcode
005030
005040                 if not w_exit_stat_OK
005050                         set w_exit_stat_INV_SORT_CODE to true
005060                 end-if
005070         end-if
005080*
005090* Customer Information
005100*
005110         if w_exit_stat_OK
005120                 move 23                 to w_istart
005130                 move 53                 to w_iend
005140                 move 'C'                to w_conversionType
005150                 move l_sCustInfo        to w_conversionString
005160
005170                 perform InsertIntoBarcode
005180         end-if
005190*
005200* Parity Symbols
005210*
005220         if w_exit_stat_OK
005230                 move 67 to w_iend
005240                 perform AppendRSParity
005250         end-if
005260*
005270* Stop Bars
005280*
005290         if w_exit_stat_OK
005300                 move 66 to              w_istart
005310                 move 67 to              w_iend
005320                 move 'B' to             w_conversionType
005330                 move w_BC_STOP_SYM to   w_conversionString
005340
005350                 perform InsertIntoBarcode
005360         end-if
005370*
005380* Copy back result, with null termination
005390*
005400         if w_exit_stat_OK
005410                 move w_sBarcode to l_sBarcode
005420                 move 67 to l_iBarcodeLen
005430         end-if
005440         .
005450
005460 InsertIntoBarcode.
005470         call "Convert" using
005480                 by reference w_sBarcode
005490                 by reference w_istart
005500                 by reference w_iend
005510                 by reference w_conversionType
005520                 by reference w_conversionString
005530                 giving w_exit_status
005540         end-call
005550         move spaces to w_conversionType
005560         .
005570
005580 AppendRSParity.
005590         if w_exit_stat_OK
005600                 call "AppendRSParity" using
005610                         by reference w_sBarcode
005620                         by reference w_iend
005630                         giving w_exit_status
005640                 end-call
005650         end-if
005660         .
005670
005680
005690  END PROGRAM BuildBarcode.
005700
005710
005720
005730
005740
005750
005760
005770
005780
005790
005800  IDENTIFICATION DIVISION.
005810*-----------------------
005820  PROGRAM-ID.             Convert.
005830* AUTHOR.                 C Nguyen.
005840* INSTALLATION.           ASPECT.
005850* DATE-WRITTEN.           18-May-1998.
005860*=================================================================
005870*  Description:
005880*  ------------
005890*
005900*   This program converts characters to bar values using the N-Table.
005910*   It converts the number of characters specified in iNumChars using
005920*   N-Table.
005930*
005940*
005950*  Modification History
005960*  --------------------
005970*  Date         Who    Ref Number  Description
005980*  -----------  ---    ----------  ------------------------------
005990*  18-May-1998  CN                 Initial version
006000*  03-Mar-1998  DW     R2          Realigned with ANSI-C version R2
006010*=================================================================
006020  ENVIRONMENT DIVISION.
006030*--------------------
006040  DATA DIVISION.
006050*------------
006060  WORKING-STORAGE SECTION.
006070*----------------------
006080  01  i pic s9(9) comp.
006090  01  j pic s9(9) comp.
006100
006110  01  w_idx pic s9(9) comp.
006120  01  w_idxLast pic s9(9) comp.
006130
006140  01  w_cellsize  pic s9 comp.
006150
006160  01  w_num pic 99.
006170
006180  01  w_barval.
006190      03  w_barval_arr occurs 3 times pic x.
006200
006210  01  w_exit_status pic s9(9) comp.
006220         88 w_exit_stat_OK             value    0.
006230         88 w_exit_stat_INV_FCC        value    1.
006240         88 w_exit_stat_INV_ENCODE_STR value    4.
006250         88 w_exit_stat_INV_RANGE      value    5.
006260
006270*
006280* Table for 'N' Digit Encoding
006290*
006300  01  NTable_val_str.
006310      03  filler pic 99 value 00.
006320      03  filler pic 99 value 01.
006330      03  filler pic 99 value 02.
006340      03  filler pic 99 value 10.
006350      03  filler pic 99 value 11.
006360      03  filler pic 99 value 12.
006370      03  filler pic 99 value 20.
006380      03  filler pic 99 value 21.
006390      03  filler pic 99 value 22.
006400      03  filler pic 99 value 30.
006410  01  NTable_str redefines NTable_val_str.
006420      03  NTable occurs 10 pic 99.
006430*
006440* Table for Uppercase alpha conversion. Z or C encoding
006450*
006460  01  ZTable_val_str.
006470      03  filler pic 999 value 000.
006480      03  filler pic 999 value 001.
006490      03  filler pic 999 value 002.
006500      03  filler pic 999 value 010.
006510      03  filler pic 999 value 011.
006520      03  filler pic 999 value 012.
006530      03  filler pic 999 value 020.
006540      03  filler pic 999 value 021.
006550      03  filler pic 999 value 022.
006560      03  filler pic 999 value 100.
006570      03  filler pic 999 value 101.
006580      03  filler pic 999 value 102.
006590      03  filler pic 999 value 110.
006600      03  filler pic 999 value 111.
006610      03  filler pic 999 value 112.
006620      03  filler pic 999 value 120.
006630      03  filler pic 999 value 121.
006640      03  filler pic 999 value 122.
006650      03  filler pic 999 value 200.
006660      03  filler pic 999 value 201.
006670      03  filler pic 999 value 202.
006680      03  filler pic 999 value 210.
006690      03  filler pic 999 value 211.
006700      03  filler pic 999 value 212.
006710      03  filler pic 999 value 220.
006720      03  filler pic 999 value 221.
006730  01  ZTable_str redefines ZTable_val_str.
006740      03  ZTable occurs 26 pic 999.
006750
006760*
006770* C-Table for encoding lowercase alphas
006780*
006790  01  CTable_val_str.
006800      03  filler pic 999 value 023.
006810      03  filler pic 999 value 030.
006820      03  filler pic 999 value 031.
006830      03  filler pic 999 value 032.
006840      03  filler pic 999 value 033.
006850      03  filler pic 999 value 103.
006860      03  filler pic 999 value 113.
006870      03  filler pic 999 value 123.
006880      03  filler pic 999 value 130.
006890      03  filler pic 999 value 131.
006900      03  filler pic 999 value 132.
006910      03  filler pic 999 value 133.
006920      03  filler pic 999 value 203.
006930      03  filler pic 999 value 213.
006940      03  filler pic 999 value 223.
006950      03  filler pic 999 value 230.
006960      03  filler pic 999 value 231.
006970      03  filler pic 999 value 232.
006980      03  filler pic 999 value 233.
006990      03  filler pic 999 value 303.
007000      03  filler pic 999 value 313.
007010      03  filler pic 999 value 323.
007020      03  filler pic 999 value 330.
007030      03  filler pic 999 value 331.
007040      03  filler pic 999 value 332.
007050      03  filler pic 999 value 333.
007060  01  CTable_str redefines CTable_val_str.
007070      03  CTable occurs 26 pic 999.
007080*
007090* CN-Table for encoding numerics using the C-table
007100*
007110  01  CNTable_val_str.
007120      03  filler pic 999 value 222.
007130      03  filler pic 999 value 300.
007140      03  filler pic 999 value 301.
007150      03  filler pic 999 value 302.
007160      03  filler pic 999 value 310.
007170      03  filler pic 999 value 311.
007180      03  filler pic 999 value 312.
007190      03  filler pic 999 value 320.
007200      03  filler pic 999 value 321.
007210      03  filler pic 999 value 322.
007220  01  CNTable_str redefines CNTable_val_str.
007230      03  CNTable occurs 10 pic 999.
007240
007250
007260  LINKAGE SECTION.
007270*---------------
007280
007290  01  l_sBarCoded.
007300      03  l_sBarcoded_arr occurs 68 pic x.
007310
007320  01  l_istart pic s9(9) comp.
007330
007340  01  l_iend pic s9(9) comp.
007350
007360  01  l_sEncodeType pic x.
007370      88 l_sEncodeTypeB values 'B', 'b'.
007380      88 l_sEncodeTypeC values 'C', 'c'.
007390      88 l_sEncodeTypeN values 'N', 'n'.
007400      88 l_sEncodeTypeZ values 'Z', 'z'.
007410
007420  01  l_InString.
007430      03  l_InString_arr occurs 20 pic x.
007440
007450
007460  PROCEDURE DIVISION
007470         using
007480                 l_sBarCoded,
007490                 l_istart,
007500                 l_iend,
007510                 l_sEncodeType,
007520                 l_Instring
007530         giving w_exit_status.
007540
007550*---------------------------------------
007560  MAIN SECTION.
007570*------------
007580  MAIN-START.
007590
007600         set w_exit_stat_OK to true
007610         if (l_istart < 1 or l_iend < l_istart)
007620                 set w_exit_stat_INV_RANGE to true
007630         end-if
007640
007650         evaluate true
007660                 when l_sEncodeTypeB
007670                         perform encodeB
007680                 when l_sEncodeTypeC
007690                         perform encodeC
007700                 when l_sEncodeTypeN
007710                         perform encodeN
007720                 when l_sEncodeTypeZ
007730                         perform encodeZ
007740                 when other
007750                         set w_exit_stat_INV_FCC to true
007760         end-evaluate
007770         .
007780
007790  MAIN-EXIT.
007800      EXIT PROGRAM.
007810
007820 encodeB.
007830*-----------------------------------------------------------------
007840* Direct Copy of barcodes. Character set 0-3
007850*-----------------------------------------------------------------
007860      move 1 to w_cellsize
007870      compute w_idxLast = l_istart + w_cellsize - 1
007880      move l_istart to w_idx
007890
007900      perform varying i from 1 by 1 until w_idxLast > l_iend
007910
007920         if l_InString_arr(i) = "0"
007930         or l_InString_arr(i) = "1"
007940         or l_InString_arr(i) = "2"
007950         or l_InString_arr(i) = "3"
007960              move l_InString_arr(i) to w_barval
007970         else
007980              move spaces to w_barval
007990              set w_exit_stat_INV_ENCODE_STR to true
008000          end-if
008010
008020         perform varying j from 1 by 1 until j > w_cellsize
008030                 move w_barval_arr(j) to  l_sBarCoded_arr(w_idx)
008040                 add 1 to w_idx
008050         end-perform
008060         add w_cellsize to w_idxLast
008070      end-perform
008080
008090      if (w_idx <= l_iend)
008100         set w_exit_stat_INV_RANGE to true
008110      end-if
008120      .
008130
008140 encodeC.
008150*-----------------------------------------------------------------
008160* Encoding of A-Z,a-z spaces and #
008170*-----------------------------------------------------------------
008180      move 3 to w_cellsize
008190      move l_istart to w_idx
008200      compute w_idxLast = l_istart + w_cellsize - 1
008210
008220      perform varying i from 1 by 1
008230         until w_idxLast > l_iend
008240         or l_InString_arr(i) = low-values
008250
008260         evaluate true
008270
008280                 when l_InString_arr(i) = " "
008290                      move "003" to w_barval
008300
008310                 when l_InString_arr(i) = "#"
008320                      move "013" to w_barval
008330
008340                 when l_InString_arr(i) is alphabetic-lower
008350                      perform LookupLower
008360                      move CTable(w_num) to w_barval
008370
008380                 when l_InString_arr(i) is alphabetic-upper
008390                      perform LookupUpper
008400                      move ZTable(w_num) to w_barval
008410
008420                 when l_InString_arr(i) is numeric
008430                      move l_InString_arr(i) to w_num
008440                      move CNTable(1 + w_num) to w_barval
008450
008460                 when other
008470                      move spaces to w_barval
008480                      set w_exit_stat_INV_ENCODE_STR to true
008490         end-evaluate
008500
008510         perform varying j from 1 by 1 until j > w_cellsize
008520                 move w_barval_arr(j) to  l_sBarCoded_arr(w_idx)
008530                 add 1 to w_idx
008540         end-perform
008550         add w_cellsize to w_idxLast
008560      end-perform
008570
008580      if (w_idx <= l_iend)
008590         perform varying j from w_idx by 1 until j > l_iend
008600                 move '3' to  l_sBarCoded_arr(j)
008610         end-perform
008620      end-if
008630         .
008640
008650 encodeN.
008660*-----------------------------------------------------------------
008670* Encoding of numerics. Character set 0-9
008680*-----------------------------------------------------------------
008690      move 2 to w_cellsize
008700      move l_istart to w_idx
008710      compute w_idxLast = l_istart + w_cellsize - 1
008720
008730      if (l_istart < 1 or l_iend < l_istart)
008740         set w_exit_stat_INV_RANGE to true
008750      end-if
008760
008770      perform varying i from 1 by 1 until w_idxLast > l_iend
008780
008790         if l_InString_arr(i) is numeric
008800                 move l_InString_arr(i) to w_num
008810                 move NTable(1 + w_num) to w_barval
008820         else
008830                 move spaces to w_barval
008840                 set w_exit_stat_INV_ENCODE_STR to true
008850         end-if
008860
008870         perform varying j from 1 by 1 until j > w_cellsize
008880                 move w_barval_arr(j) to  l_sBarCoded_arr(w_idx)
008890                 add 1 to w_idx
008900         end-perform
008910         add w_cellsize to w_idxLast
008920      end-perform
008930
008940      if (w_idx <= l_iend)
008950         set w_exit_stat_INV_RANGE to true
008960      end-if
008970      .
008980
008990 encodeZ.
009000*-----------------------------------------------------------------
009010* Encoding of Uppercase Alphas A-Z
009020*-----------------------------------------------------------------
009030      move 3 to w_cellsize
009040      compute w_idxLast = l_istart + w_cellsize - 1
009050      move l_istart to w_idx
009060
009070      perform varying i from 1 by 1
009080         until w_idxLast > l_iend
009090         or l_InString_arr(i) = low-values
009100
009110          if l_InString_arr(i) is alphabetic-upper
009120              perform LookupUpper
009130              move ZTable(w_num) to w_barval
009140          else
009150              move spaces to w_barval
009160              set w_exit_stat_INV_ENCODE_STR to true
009170          end-if
009180
009190         perform varying j from 1 by 1 until j > w_cellsize
009200                 move w_barval_arr(j) to  l_sBarCoded_arr(w_idx)
009210                 add 1 to w_idx
009220         end-perform
009230         add w_cellsize to w_idxLast
009240      end-perform
009250
009260      if (w_idx <= l_iend)
009270         perform varying j from w_idx by 1 until j > l_iend
009280                 move '3' to  l_sBarCoded_arr(j)
009290         end-perform
009300      end-if
009310      .
009320
009330 LookupUpper.
009340*-----------------------------------------------------------------
009350* Convert an uppercase character to an ordinance number
009360*-----------------------------------------------------------------
009370         evaluate l_InString_arr(i)
009380            when 'A'    move 01 to w_num
009390            when 'B'    move 02 to w_num
009400            when 'C'    move 03 to w_num
009410            when 'D'    move 04 to w_num
009420            when 'E'    move 05 to w_num
009430            when 'F'    move 06 to w_num
009440            when 'G'    move 07 to w_num
009450            when 'H'    move 08 to w_num
009460            when 'I'    move 09 to w_num
009470            when 'J'    move 10 to w_num
009480            when 'K'    move 11 to w_num
009490            when 'L'    move 12 to w_num
009500            when 'M'    move 13 to w_num
009510            when 'N'    move 14 to w_num
009520            when 'O'    move 15 to w_num
009530            when 'P'    move 16 to w_num
009540            when 'Q'    move 17 to w_num
009550            when 'R'    move 18 to w_num
009560            when 'S'    move 19 to w_num
009570            when 'T'    move 20 to w_num
009580            when 'U'    move 21 to w_num
009590            when 'V'    move 22 to w_num
009600            when 'W'    move 23 to w_num
009610            when 'X'    move 24 to w_num
009620            when 'Y'    move 25 to w_num
009630            when 'Z'    move 26 to w_num
009640         end-evaluate
009650         .
009660
009670
009680 LookupLower.
009690*-----------------------------------------------------------------
009700* Convert a lowercase character to an ordinance number
009710*-----------------------------------------------------------------
009720         evaluate l_InString_arr(i)
009730            when 'a'    move 01 to w_num
009740            when 'b'    move 02 to w_num
009750            when 'c'    move 03 to w_num
009760            when 'd'    move 04 to w_num
009770            when 'e'    move 05 to w_num
009780            when 'f'    move 06 to w_num
009790            when 'g'    move 07 to w_num
009800            when 'h'    move 08 to w_num
009810            when 'i'    move 09 to w_num
009820            when 'j'    move 10 to w_num
009830            when 'k'    move 11 to w_num
009840            when 'l'    move 12 to w_num
009850            when 'm'    move 13 to w_num
009860            when 'n'    move 14 to w_num
009870            when 'o'    move 15 to w_num
009880            when 'p'    move 16 to w_num
009890            when 'q'    move 17 to w_num
009900            when 'r'    move 18 to w_num
009910            when 's'    move 19 to w_num
009920            when 't'    move 20 to w_num
009930            when 'u'    move 21 to w_num
009940            when 'v'    move 22 to w_num
009950            when 'w'    move 23 to w_num
009960            when 'x'    move 24 to w_num
009970            when 'y'    move 25 to w_num
009980            when 'z'    move 26 to w_num
009990         end-evaluate
010000         .
010010
010020  END PROGRAM Convert.
010030
010040
010050
010060
010070
010080
010090
010100
010110
010120
010130  IDENTIFICATION DIVISION.
010140*-----------------------
010150  PROGRAM-ID.             AppendRSParity.
010160* AUTHOR.                 C Nguyen.
010170* INSTALLATION.           ASPECT.
010180* DATE-WRITTEN.           18-May-1998.
010190*=================================================================
010200*  Description:
010210*  ------------
010220*
010230*   This function calculated the number of info symbols in the bar
010240*   It then converts each group of 3 bars into their decimal equivalents.
010250*   It then calls the initialise function to initialise the RS Encoder.
010260*   It then calls the RSEncode function to generate the 4 parity symbols
010270*   These parity symbols are then converted to their group of 3 bars
010280*   equivalent and are appended to the end of the original barcode.
010290*
010300*  Input:
010310*  Output:
010320*
010330*  Modification History
010340*  --------------------
010350*  Date         Who    Ref Number  Description
010360*  -----------  ---    ----------  --------------------------------
010370*  18-May-1998  CN                 Initial version
010380*  03-Mar-1998  DW     R2          Realigned with ANSI-C version R2
010390*==================================================================
010400  ENVIRONMENT DIVISION.
010410*--------------------
010420  DATA DIVISION.
010430*------------
010440  WORKING-STORAGE SECTION.
010450*----------------------
010460  01  w_exit_status pic s9(9) comp.
010470         88 w_exit_stat_OK             value    0.
010480
010490  01  w_idx pic s9(9) comp.
010500
010510  01  w_iBarLength pic s9(9) comp.
010520
010530  01  w_done_status pic x.
010540      88  w_done value 'D'.
010550      88  w_done_not value 'N'.
010560
010570  01  iSymbols pic s9(9) comp.
010580  01  iNumInfoSymbols pic s9(9) comp.
010590
010600  01  i pic s9(9) comp.
010610  01  j pic s9(9) comp.
010620
010630  01  sBarGroup.
010640      03 sBarGroup_arr occurs 3 times pic x.
010650  01  sBarGroup_N redefines sBarGroup pic 9(3).
010660
010670  01  iCodeWord_str.
010680      03  iCodeWord occurs 31 pic 9(9) comp.
010690
010700  01  iTempCodeWord_str.
010710      03  iTempCodeWord occurs 31 pic 9(9) comp.
010720
010730  01  paritysymbols.
010740*   Global Structure for the 4 parity symbols
010750      03  v_in occurs 4 pic 9(9) comp.
010760
010770  01  BarTable_val_str.
010780      03  filler pic x(3) value "000".
010790      03  filler pic x(3) value "001".
010800      03  filler pic x(3) value "002".
010810      03  filler pic x(3) value "003".
010820      03  filler pic x(3) value "010".
010830      03  filler pic x(3) value "011".
010840      03  filler pic x(3) value "012".
010850      03  filler pic x(3) value "013".
010860      03  filler pic x(3) value "020".
010870      03  filler pic x(3) value "021".
010880      03  filler pic x(3) value "022".
010890      03  filler pic x(3) value "023".
010900      03  filler pic x(3) value "030".
010910      03  filler pic x(3) value "031".
010920      03  filler pic x(3) value "032".
010930      03  filler pic x(3) value "033".
010940      03  filler pic x(3) value "100".
010950      03  filler pic x(3) value "101".
010960      03  filler pic x(3) value "102".
010970      03  filler pic x(3) value "103".
010980      03  filler pic x(3) value "110".
010990      03  filler pic x(3) value "111".
011000      03  filler pic x(3) value "112".
011010      03  filler pic x(3) value "113".
011020      03  filler pic x(3) value "120".
011030      03  filler pic x(3) value "121".
011040      03  filler pic x(3) value "122".
011050      03  filler pic x(3) value "123".
011060      03  filler pic x(3) value "130".
011070      03  filler pic x(3) value "131".
011080      03  filler pic x(3) value "132".
011090      03  filler pic x(3) value "133".
011100      03  filler pic x(3) value "200".
011110      03  filler pic x(3) value "201".
011120      03  filler pic x(3) value "202".
011130      03  filler pic x(3) value "203".
011140      03  filler pic x(3) value "210".
011150      03  filler pic x(3) value "211".
011160      03  filler pic x(3) value "212".
011170      03  filler pic x(3) value "213".
011180      03  filler pic x(3) value "220".
011190      03  filler pic x(3) value "221".
011200      03  filler pic x(3) value "222".
011210      03  filler pic x(3) value "223".
011220      03  filler pic x(3) value "230".
011230      03  filler pic x(3) value "231".
011240      03  filler pic x(3) value "232".
011250      03  filler pic x(3) value "233".
011260      03  filler pic x(3) value "300".
011270      03  filler pic x(3) value "301".
011280      03  filler pic x(3) value "302".
011290      03  filler pic x(3) value "303".
011300      03  filler pic x(3) value "310".
011310      03  filler pic x(3) value "311".
011320      03  filler pic x(3) value "312".
011330      03  filler pic x(3) value "313".
011340      03  filler pic x(3) value "320".
011350      03  filler pic x(3) value "321".
011360      03  filler pic x(3) value "322".
011370      03  filler pic x(3) value "323".
011380      03  filler pic x(3) value "330".
011390      03  filler pic x(3) value "331".
011400      03  filler pic x(3) value "332".
011410      03  filler pic x(3) value "333".
011420  01  BarTable_str redefines BarTable_val_str.
011430      03  BarTable occurs 64 pic 999.
011440
011450  LINKAGE SECTION.
011460*---------------
011470  01  l_sBarcode.
011480     03 l_sBarcode_arr occurs 68 times pic x.
011490
011500  01  l_iBarLength pic s9(6) comp.
011510
011520  PROCEDURE DIVISION
011530         using   l_sBarcode,
011540                 l_iBarLength
011550         giving  w_exit_status.
011560
011570*-------------------------------------------------
011580  MAIN SECTION.
011590*------------
011600  MAIN-START.
011610
011620      set w_exit_stat_OK to true
011630*   Calc the number of symbols & info symbols for the barcode
011640      compute iSymbols = (l_iBarLength - 4) / 3
011650      compute iNumInfoSymbols = iSymbols - 4;
011660
011670*   For the purposes of RS Parity generation the barcode string
011680*   consists of a number of 3 bar information symbols. Each
011690*   group of 3 bars must be converted to it's decimal equivalent.
011700*   This is performed by:
011710*    - setting sBarGroup to the 3 bars
011720*    - comparing sBarGroup to each element of BarTable until a
011730*      match is found
011740*    - then setting iCodeWord[i] to the decimal entry number from
011750*      BarTable
011760
011770      perform varying i from 1 by 1 until i > iNumInfoSymbols
011780*       where does the next group of barcode start ?
011790          compute w_idx = ((i - 1) * 3) + 2
011800*       extract it
011810          move l_sBarcode_arr(1+w_idx) to sBarGroup_arr(1)
011820          move l_sBarcode_arr(2+w_idx) to sBarGroup_arr(2)
011830          move l_sBarcode_arr(3+w_idx) to sBarGroup_arr(3)
011840*       search the BarTable
011850          set w_done_not to true
011860          perform varying j from 1 by 1 until j > 64 or w_done
011870              if BarTable(j) = sBarGroup_N
011880                  subtract 1 from j giving iCodeWord(i)
011890                  set w_done to true
011900              end-if
011910          end-perform
011920      end-perform
011930
011940*   Set the parity check symbols to zero in the code word
011950      perform varying i from iNumInfoSymbols by 1
011960                until i >= iSymbols
011970          move zero to iCodeWord(1 + i)
011980      end-perform
011990
012000*   Now we must convert the symbol order from 1,2,3.. to ..3,2,1
012010      subtract 1 from iNumInfoSymbols giving j
012020      perform varying i from 0 by 1 until i >= iNumInfoSymbols
012030          move iCodeWord(1 + j) to iTempCodeWord(1 + i)
012040          subtract 1 from j
012050      end-perform
012060
012070*   Call RSEncode to get the parity symbols
012080      call "RSEncode" using iNumInfoSymbols
012090                           ,iTempCodeWord_str
012100                           ,paritysymbols
012110
012120*   Add the RS Parity Symbols to the end of the code word
012130*   Don't forget to convert 4,3,2,1 to 1,2,3,4
012140      perform varying i from 1 by 1 until i > 4
012150          move v_in of paritysymbols(5 - i)
012160            to iCodeWord(i + iNumInfoSymbols)
012170      end-perform
012180
012190*   Now we need to grab the 4 parity symbols returned
012200*   & append them to our bar code string
012210
012220      perform varying i from iNumInfoSymbols by 1
012230                until i >= iSymbols
012240          move BarTable(1 + iCodeWord(1 + i)) to sBarGroup
012250
012260            compute w_idx = (i * 3) + 2
012270
012280            move sBarGroup_arr(1) to l_sBarCode_arr(w_idx + 1)
012290            move sBarGroup_arr(2) to l_sBarCode_arr(w_idx + 2)
012300            move sBarGroup_arr(3) to l_sBarCode_arr(w_idx + 3)
012310      end-perform
012320      .
012330  MAIN-EXIT.
012340      EXIT PROGRAM.
012350
012360  END PROGRAM AppendRSParity.
012370
012380
012390
012400
012410
012420
012430
012440
012450
012460
012470  IDENTIFICATION DIVISION.
012480*-----------------------
012490  PROGRAM-ID.             RSEncode.
012500* AUTHOR.                 C Nguyen.
012510* INSTALLATION.           ASPECT.
012520* DATE-WRITTEN.           18-May-1998.
012530*=================================================================
012540*  Description:
012550*  ------------
012560*
012570*   This program generates the Reed-Solomon Parity symbols.
012580*
012590*
012600*  Modification History
012610*  --------------------
012620*  Date         Who   Ref Number  Description
012630*  -----------  ---   ----------  -------------------------------
012640*  18-May-1998  CN                Initial version
012650*  03-Mar-1998  DW    R2          Realigned with ANSI-C version R2
012660*=================================================================
012670  ENVIRONMENT DIVISION.
012680*--------------------
012690  DATA DIVISION.
012700*------------
012710  WORKING-STORAGE SECTION.
012720*----------------------
012730  01  n pic s9(9) comp.
012740  01  k pic s9(9) comp.
012750  01  i pic s9(9) comp.
012760  01  j pic s9(9) comp.
012770  01  l pic s9(9) comp.
012780
012790  01  w_first_time_flag pic x value " ".
012800      88  w_first_time_no_more value "2".
012810
012820  01  temp_str.
012830      03  temp occurs 31 pic 9(9) comp.
012840
012850  01  w_parity4_str.
012860      03  v_in occurs 4 pic 9(9) comp.
012870
012880  01  mult_str.
012890*   Global variable : The multiplication table for Galois field
012905*                     arithmetic
012900      03  mult_1 occurs 64.
012910          05  mult_2 occurs 64.
012920              07  mult pic s9(9) comp.
012930
012940  01  gen_str.
012950*   Global variable : The generator polynomial g(x)
012960      03  gen occurs 5 pic s9(9) comp.
012970
012980  LINKAGE SECTION.
012990*---------------
013000  01  l_num_infosym pic s9(9) comp.
013010  01  l_infosymbols_str.
013020      03  l_infosymbols occurs 31 pic s9(9) comp.
013030  01  l_paritystring_str.
013040      03  v_in occurs 4 pic 9(9) comp.
013050
013060  PROCEDURE DIVISION USING l_num_infosym
013070                          ,l_infosymbols_str
013080                          ,l_paritystring_str.
013090*--------------------------------------------
013100  MAIN SECTION.
013110*------------
013120  MAIN-START.
013130*   Initialise buffers
013140      if not w_first_time_no_more
013150          call "RSInitialise" using mult_str, gen_str
013160          set w_first_time_no_more to true
013170      end-if
013180
013190*   Calc the code params n & k from Num_infosym
013200      move l_num_infosym to k
013210      add 4 to k giving n
013220
013230*   The temp array is initialised with x^(n-k) m(x).  After
013240*   division by g(x), temp will contain the parity symbols,
013250*   p(x), in locations 0 to 4. Note that p(x) is the remainder
013260*   after the division operation.
013270
013280      perform varying i from 0 by 1 until i >= 4
013290          move zero to temp(1 + i)
013300      end-perform
013310
013320      perform varying i from 4 by 1 until i >= n
013330          move l_infosymbols(1 + i - 4) to temp(1 + i)
013340      end-perform
013350
013360*   Perform the division by the generator polynomial g(x).
013370*   This is accomplished using k iterations of long division,
013380*   where g(x) times the most significant symbol in the
013390*   dividend are subtracted.
013400
013410      compute l = k - 1
013420      perform varying i from l by -1 until i < 0
013430          perform varying j from 0 by 1 until j > 4
013440              call "BitXor" using temp(1 + i + j)
013450                                 ,mult(1 + gen(1 + j)
013460                                      ,1 + temp(1 + 4 + i))
013470                           giving temp(1 + i + j)
013480          end-perform
013490      end-perform
013500
013510      perform varying i from 0 by 1 until i >= 4
013520*       Place the parity symbols in the parity array
013530          move temp(1 + i) to v_in of w_parity4_str(1 + i)
013540      end-perform
013550
013560      move w_parity4_str to l_paritystring_str
013570      .
013580  MAIN-EXIT.
013590      EXIT PROGRAM.
013600
013610
013620
013630
013640
013650
013660
013670
013680
013690
013700
013710  IDENTIFICATION DIVISION.
013720*-----------------------
013730  PROGRAM-ID.             RSInitialise.
013740* AUTHOR.                 C Nguyen.
013750* INSTALLATION.           ASPECT.
013760* DATE-WRITTEN.           18-May-1998.
013770*=================================================================
013780*  Description:
013790*  ------------
013800*
013810*   This program initialises the Reed-Solomon Parity generator.
013820*
013830*
013840*  Modification History
013850*  --------------------
013860*  Date         Who   Ref Number  Description
013870*  -----------  ---   ----------  -------------------------------
013880*  18-May-1998  CN                Initial version
013890*  03-Mar-1998  DW    R2          Realigned with ANSI-C version R2
013900*=================================================================
013910  ENVIRONMENT DIVISION.
013920*--------------------
013930  DATA DIVISION.
013940*------------
013950  WORKING-STORAGE SECTION.
013960*----------------------
013970  01  w_primpoly pic 9(9) comp.
013980  01  w_test pic 9(9) comp.
013990  01  w_prev pic 9(9) comp.
014000  01  w_next pic 9(9) comp.
014010
014020  01  w_temp pic 9(9) comp.
014030
014040  01  i pic s9(9) comp.
014050  01  j pic s9(9) comp.
014060
014070  LINKAGE SECTION.
014080*---------------
014090  01  mult_str.
014100*   Global variable : The multiplication table for Galois field
014105*                     arithmetic
014110      03  mult_1 occurs 64.
014120          05  mult_2 occurs 64.
014130              07  mult pic s9(9) comp.
014140
014150  01  gen_str.
014160*   Global variable : The generator polynomial g(x)
014170      03  gen occurs 5 pic s9(9) comp.
014180
014190  PROCEDURE DIVISION using mult_str, gen_str.
014200*------------------------------------------
014210  MAIN SECTION.
014220*------------
014230  MAIN-START.
014240*   Sets up the constants required.  W_PRIMPOLY is a binary
014245*   representation of the primitive polynomial used to construct
014250*   the GALOIS field GF(64).
014260*   W_TEST is used to check when an element must be reduced modulo
014270*   w_primpoly.
014280      move 67 to w_primpoly
014290      move 64 to w_test
014300
014310*   The mult[][] array provides lookup table multiplication in
014320*   GF(64). The two array indices are the elements to be
014330*   multiplied, and the corresponding value is the product.
014340*   Mult a field element by 0 is 0 and mult by 1 is itself
014350      perform varying i from 0 by 1 until i >= 64
014360          move zero to mult(0 + 1,i + 1)
014370          move i to mult(1 + 1,i + 1)
014380      end-perform
014390
014400*   Multiplication by elements other than 0 or 1 requires the
014410*   corresponding powers of alpha which is a root of w_primpoly.
014420*
014430*   Beginning with the zero power of alpha, which is 1,
014440*   successive powers of alpha are obtained by shifting to the
014450*   left. If the result exceeds 6 bits, then it is reduced modulo
014460*   w_primpoly.  The rows of mult[][] are filled iteratively
014470*   according to these powers.  Note that the `powers of alpha'
014480*   representation is logarithmic, so that multiplication
014490*   requires just an addition.  w_prev is the previous power of
014500*   alpha, and w_next is the w_next power.  Because of the above
014510*   mentioned property of logarithms, the w_next row is just the
014520*   w_prev row shifted to the left.
014530      move 1 to w_prev
014540      perform varying i from 1 by 1 until i >= 64
014550*       Shift left (= multiplied by 2)
014560          compute w_next = w_prev * 2
014570          call "BitAnd" using w_next, w_test giving w_temp
014580          if w_temp > 0
014590              call "BitXor" using w_next
014600                                 ,w_primpoly
014610                           giving w_next
014620          end-if
014630          perform varying j from 0 by 1 until j >= 64
014640              compute mult(w_next + 1,j + 1)
014650                    = mult(w_prev + 1,j + 1) * 2
014660              call "BitAnd" using mult(w_next + 1,j + 1)
014670                                      ,w_test
014680                                giving w_temp
014690              if w_temp > 0
014700                  call "BitXor" using mult(w_next + 1,j + 1)
014710                                     ,w_primpoly
014720                               giving mult(w_next + 1,j + 1)
014730              end-if
014740          end-perform
014750          move w_next to w_prev
014760      end-perform
014770*   Initialise the generator polynomial
014780      move 48 to gen(0 + 1)
014790      move 17 to gen(1 + 1)
014800      move 29 to gen(2 + 1)
014810      move 30 to gen(3 + 1)
014820      move 01 to gen(4 + 1)
014830      .
014840  MAIN-EXIT.
014850      EXIT PROGRAM.
014860
014870  END PROGRAM RSInitialise.
014880  END PROGRAM RSEncode.
014890
014900
014910
014920
014930
014940
014950
014960
014970
014980
014990  IDENTIFICATION DIVISION.
015000*-----------------------
015010  PROGRAM-ID.             BitXor.
015020* AUTHOR.                 C Nguyen.
015030* INSTALLATION.           ASPECT.
015040* DATE-WRITTEN.           18-May-1998.
015050*=================================================================
015060*  Description:
015070*  ------------
015080*
015090*   This program accepts as parameters two longword, and returns
015100*   the bitwise-exclusive-ORED result of the two numbers.
015110*
015120*  Input:
015130*  Output:
015140*
015150*  Modification History
015160*  --------------------
015170*  Date         Who      Ref Number        Description
015180*  -----------  ---      --------------    -----------------------
015190*  18-May-1998  CN                         Initial version
015200*  04-Mar-1999  DW       R2                Optimised
015210*=================================================================
015220  ENVIRONMENT DIVISION.
015230*--------------------
015240  DATA DIVISION.
015250*------------
015260  WORKING-STORAGE SECTION.
015270*----------------------
015280  01  W_RETURN_NUM pic 9(9) comp.
015290
015300  01  W_NUM_1 pic 9(9) comp.
015310  01  W_NUM_1_BIT pic 9 comp.
015320
015330  01  W_NUM_2 pic 9(9) comp.
015340  01  W_NUM_2_BIT pic 9 comp.
015350
015360  01  W_NUM_3 pic 9(9) comp.
015370
015380  01  W_BIT  pic 9(9) comp.
015390
015400  LINKAGE SECTION.
015410*---------------
015420  01 LNK_NUM_1 pic 9(9) comp.
015430  01 LNK_NUM_2 pic 9(9) comp.
015440
015450  PROCEDURE DIVISION USING LNK_NUM_1
015460                           LNK_NUM_2
015470                    GIVING W_RETURN_NUM.
015480*--------------------------------------------
015490  MAIN SECTION.
015500*------------
015510  MAIN-START.
015520      MOVE 0 to W_RETURN_NUM
015530      MOVE 1 to W_BIT
015540
015550      MOVE LNK_NUM_1 TO W_NUM_1
015560      MOVE LNK_NUM_2 TO W_NUM_2
015570      PERFORM UNTIL W_NUM_1 = 0 and W_NUM_2 = 0
015580*       Get the bit from NUM_1
015590          DIVIDE W_NUM_1 BY 2 GIVING W_NUM_1
015600                 REMAINDER W_NUM_1_BIT
015610
015620*       Get the bit from NUM_2
015630          DIVIDE W_NUM_2 BY 2 GIVING W_NUM_2
015640                 REMAINDER W_NUM_2_BIT
015650
015660*       Exclusively ORed the bits
015670          IF (W_NUM_1_BIT NOT = W_NUM_2_BIT)
015680              ADD W_BIT to W_RETURN_NUM
015690          END-IF
015700*       Shift significant bit
015710          MULTIPLY W_BIT BY 2 GIVING W_BIT
015720
015730      END-PERFORM
015740      .
015750  MAIN-EXIT.
015760      EXIT PROGRAM.
015770
015780  END PROGRAM  BitXor.
015790
015800
015810
015820
015830
015840
015850
015860
015870
015880
015890  IDENTIFICATION DIVISION.
015900*-----------------------
015910  PROGRAM-ID.             BitAnd.
015920* AUTHOR.                 C Nguyen.
015930* INSTALLATION.           ASPECT.
015940* DATE-WRITTEN.           18-May-1998.
015950*=================================================================
015960*  Description:
015970*  ------------
015980*
015990*   This program accepts as parameters two longword, and returns
016000*   the bitwise-exclusive-ORED result of the two numbers.
016010*
016020*  Input:
016030*  Output:
016040*
016050*  Modification History
016060*  --------------------
016070*  Date         Who      Ref Number        Description
016080*  -----------  ---      --------------    -----------------------
016090*  18-May-1998  CN                         Initial version
016100*  04-Mar-1999  DW       R2                Optimised
016110*=================================================================
016120  ENVIRONMENT DIVISION.
016130*--------------------
016140  DATA DIVISION.
016150*------------
016160  WORKING-STORAGE SECTION.
016170*----------------------
016180  01  W_RETURN_NUM pic 9(9) comp.
016190
016200  01  W_NUM_1 pic 9(9) comp.
016210  01  W_NUM_1_BIT pic 9 comp.
016220
016230  01  W_NUM_2 pic 9(9) comp.
016240  01  W_NUM_2_BIT pic 9 comp.
016250
016260  01  W_NUM_3 pic 9(9) comp.
016270
016280  01  W_BIT  pic 9(9) comp.
016290
016300  LINKAGE SECTION.
016310*---------------
016320  01 LNK_NUM_1 pic 9(9) comp.
016330  01 LNK_NUM_2 pic 9(9) comp.
016340
016350  PROCEDURE DIVISION USING LNK_NUM_1
016360                           LNK_NUM_2
016370                    GIVING W_RETURN_NUM.
016380*--------------------------------------------
016390  MAIN SECTION.
016400*------------
016410  MAIN-START.
016420      MOVE 0 to W_RETURN_NUM
016430      MOVE 1 to W_BIT
016440
016450      MOVE LNK_NUM_1 TO W_NUM_1
016460      MOVE LNK_NUM_2 TO W_NUM_2
016470      PERFORM UNTIL W_NUM_1 = 0 and W_NUM_2 = 0
016480*       Get the bit from NUM_1
016490          DIVIDE W_NUM_1 BY 2 GIVING W_NUM_1
016500                 REMAINDER W_NUM_1_BIT
016510
016520*       Get the bit from NUM_2
016530          DIVIDE W_NUM_2 BY 2 GIVING W_NUM_2
016540                 REMAINDER W_NUM_2_BIT
016550
016560*       Exclusively ORed the bits
016570          IF W_NUM_1_BIT > 0 AND W_NUM_2_BIT > 0
016580              ADD W_BIT to W_RETURN_NUM
016590          END-IF
016600*       Shift significant bit
016610          MULTIPLY W_BIT BY 2 GIVING W_BIT
016620
016630      END-PERFORM
016640      .
016650  MAIN-EXIT.
016660      EXIT PROGRAM.
016670
016680  END PROGRAM  BitAnd.

